/*
 * Decompiled with CFR 0.152.
 */
package psyq.structs;

import com.udojava.evalex.Expression;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import psyq.structs.Symbol;

public final class PatchInfo {
    private final int type;
    private final int offset;
    private final int patchOffset;
    private final int sectionIndex;
    private String reference;
    private boolean toExternal = false;
    private int externalIndex = 0;

    public final int getType() {
        return this.type;
    }

    public final int getOffset() {
        return this.patchOffset + this.offset;
    }

    public final int getSectionIndex() {
        return this.sectionIndex;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean isExternal() {
        return this.toExternal;
    }

    public int getExternalIndex() {
        return this.externalIndex;
    }

    public PatchInfo(int patchOffset, int sectionIndex, BinaryReader reader, MessageLog log) throws IOException {
        this.type = reader.readNextByte();
        this.patchOffset = patchOffset;
        this.offset = reader.readNextUnsignedShort();
        this.sectionIndex = sectionIndex;
        this.reference = "";
        this.readPatchInfo(reader, log);
    }

    public long calcReference(HashMap<Integer, Symbol> symbols) throws NumberFormatException {
        int val3;
        int val2;
        int val1;
        long address;
        this.toExternal = false;
        this.externalIndex = 0;
        Object ref = this.reference;
        ref = ((String)ref).replaceAll("\\$([0-9A-Fa-f]+)", "0x$1");
        Matcher m = Pattern.compile("\\[([0-9A-Fa-f]+)\\]").matcher((CharSequence)ref);
        while (m.find()) {
            this.externalIndex = Integer.parseInt(m.group(1), 16);
            long address2 = symbols.get(this.externalIndex).getAddress();
            ref = ((String)ref).substring(0, m.start()) + String.format("0x%X", address2) + ((String)ref).substring(m.end());
            this.toExternal = true;
        }
        m = Pattern.compile("sectbase\\(([0-9A-Fa-f]+)\\)").matcher((CharSequence)ref);
        while (m.find()) {
            int sectIndex = Integer.parseInt(m.group(1), 16);
            address = symbols.get(sectIndex).getAddress();
            ref = ((String)ref).substring(0, m.start()) + String.format("0x%X", address) + ((String)ref).substring(m.end());
        }
        m = Pattern.compile("sectstart\\(([0-9A-Fa-f]+)\\)").matcher((CharSequence)ref);
        while (m.find()) {
            int sectIndex = Integer.parseInt(m.group(1), 16);
            address = symbols.get(sectIndex).getAddress();
            ref = ((String)ref).substring(0, m.start()) + String.format("0x%X", address) + ((String)ref).substring(m.end());
        }
        m = Pattern.compile("sectend\\(([0-9A-Fa-f]+)\\)").matcher((CharSequence)ref);
        while (m.find()) {
            int sectIndex = Integer.parseInt(m.group(1), 16);
            Symbol sect = symbols.get(sectIndex);
            long address3 = sect.getAddress() + sect.getLength();
            ref = ((String)ref).substring(0, m.start()) + String.format("0x%X", address3) + ((String)ref).substring(m.end());
        }
        ref = ((String)ref).replaceAll("\\!", "\\+");
        m = Pattern.compile("0x([0-9A-Fa-f]+) \\- 0x([0-9A-Fa-f]+)").matcher((CharSequence)ref);
        if (m.find() && (val1 = Integer.parseInt(m.group(1), 16)) < (val2 = Integer.parseInt(m.group(2), 16))) {
            ref = String.format("0x%X - 0x%X", val2, val1);
        }
        if ((m = Pattern.compile("0x([0-9A-Fa-f]+) \\- \\(0x([0-9A-Fa-f]+) \\+ 0x([0-9A-Fa-f]+)\\)").matcher((CharSequence)ref)).find() && (val1 = Integer.parseInt(m.group(1), 16)) < (val2 = Integer.parseInt(m.group(2), 16)) + (val3 = Integer.parseInt(m.group(3), 16))) {
            ref = String.format("(0x%X + 0x%X) - 0x%X", val2, val3, val1);
        }
        if ((m = Pattern.compile("0x([0-9A-Fa-f]+) / \\(0x([0-9A-Fa-f]+) \\- 0x([0-9A-Fa-f]+)\\)").matcher((CharSequence)ref)).find()) {
            val1 = Integer.parseInt(m.group(1), 16);
            val2 = Integer.parseInt(m.group(2), 16);
            val3 = Integer.parseInt(m.group(3), 16);
            ref = String.format("(0x%X - 0x%X) / 0x%X", val2, val3, val1);
        }
        return new Expression((String)ref).eval().longValue() & 0xFFFFFFFFFFFFFFFFL;
    }

    private void readPatchInfo(BinaryReader reader, MessageLog log) throws IOException {
        byte tagType = reader.readNextByte();
        switch (tagType) {
            case 0: {
                this.reference = this.reference + String.format("$%X", reader.readNextUnsignedInt());
                break;
            }
            case 2: {
                int refIndex = reader.readNextUnsignedShort();
                this.reference = this.reference + String.format("[%X]", refIndex);
                break;
            }
            case 4: {
                this.reference = this.reference + String.format("sectbase(%X)", reader.readNextUnsignedShort());
                break;
            }
            case 12: {
                this.reference = this.reference + String.format("sectstart(%X)", reader.readNextUnsignedShort());
                break;
            }
            case 22: {
                this.reference = this.reference + String.format("sectend(%X)", reader.readNextUnsignedShort());
                break;
            }
            default: {
                this.reference = this.reference + "(";
                this.readPatchInfo(reader, log);
                switch (tagType) {
                    case 44: {
                        this.reference = this.reference + " + ";
                        break;
                    }
                    case 46: {
                        this.reference = this.reference + " - ";
                        break;
                    }
                    case 50: {
                        this.reference = this.reference + " / ";
                        break;
                    }
                    case 54: {
                        this.reference = this.reference + " ! ";
                        break;
                    }
                    default: {
                        log.appendException((Throwable)new Exception(String.format("Unknown patch type: %02X", this.type)));
                    }
                }
                this.readPatchInfo(reader, log);
                this.reference = this.reference + ")";
            }
        }
    }
}

