#ifndef _PSXSDK_RUNEXE_H
#define _PSXSDK_RUNEXE_H

/**
 * Replaces running executable code with code from another executable
 * stored in a memory buffer and starts executing at the starting point for the new code.
 * The executable must be in PSX-EXE format (such as generated by elf2exe).
 * Moreover, PSX_InitEx() must have been initialized by specifying the PSX_INIT_SAVESTATE flag.
 * @param exeBuffer Pointer to memory buffer where executable is stored
 * @return On success this function has the effect of making the PlayStation
 * run another executable, so obviously this function will never return in that case.
 * This function will only return on failure, where it will return 0.
 */
 
int PSX_RunExe(void *exeBuffer);

#endif
