/*
 * Decompiled with CFR 0.152.
 */
package psyq;

import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.Assemblers;
import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.app.plugin.core.reloc.InstructionStasher;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.framework.model.DomainObject;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import psyq.structs.BlockEnd;
import psyq.structs.BlockStart;
import psyq.structs.DefinedFile;
import psyq.structs.Definition;
import psyq.structs.Definition2;
import psyq.structs.FileLine;
import psyq.structs.FunctionEnd;
import psyq.structs.FunctionStart;
import psyq.structs.Group;
import psyq.structs.LocalSymbol;
import psyq.structs.PatchInfo;
import psyq.structs.RegisterPatch;
import psyq.structs.RepeatedData;
import psyq.structs.Section;
import psyq.structs.Symbol;
import psyq.structs.XbssSymbol;
import psyq.structs.XdefSymbol;
import psyq.structs.XrefSymbol;

public class PsyqLoader
extends AbstractLibrarySupportLoader {
    private HashMap<Integer, Long> runPoints = new HashMap();
    private int sectionSwitch = 0;
    private List<PatchInfo> patches = new ArrayList<PatchInfo>();
    private List<XdefSymbol> xdefs = new ArrayList<XdefSymbol>();
    private HashMap<Integer, Symbol> symbols = new HashMap();
    private HashMap<Integer, XrefSymbol> xrefs = new HashMap();
    private HashMap<Integer, Section> sections = new HashMap();
    private List<LocalSymbol> locals = new ArrayList<LocalSymbol>();
    private List<Group> groups = new ArrayList<Group>();
    private List<RegisterPatch> regPatches = new ArrayList<RegisterPatch>();
    private List<DefinedFile> defFiles = new ArrayList<DefinedFile>();
    private FileLine fileLine = new FileLine();
    private List<LocalSymbol> vlocals = new ArrayList<LocalSymbol>();
    private HashMap<Integer, Byte> mxInfos = new HashMap();
    private HashMap<Integer, List<XbssSymbol>> xbssList = new HashMap();
    private List<RepeatedData> repeatedData = new ArrayList<RepeatedData>();
    private List<FunctionStart> functionStarts = new ArrayList<FunctionStart>();
    private List<FunctionEnd> functionEnds = new ArrayList<FunctionEnd>();
    private List<BlockStart> blockStarts = new ArrayList<BlockStart>();
    private List<BlockEnd> blockEnds = new ArrayList<BlockEnd>();
    private List<Definition> defs = new ArrayList<Definition>();
    private List<Definition2> defs2 = new ArrayList<Definition2>();

    public String getName() {
        return "Psx PsyQ Object Files Loader";
    }

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        byte version;
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        BinaryReader reader = new BinaryReader(provider, true);
        String tag = reader.readAsciiString(0L, 3);
        if (tag.equals("LNK") && (version = reader.readByte(3L)) == 2) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, new LanguageCompilerSpecPair("MIPS:LE:32:default", "default"), true));
        }
        return loadSpecs;
    }

    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws CancelledException, IOException {
        SymbolTable symTbl = program.getSymbolTable();
        Listing listing = program.getListing();
        BinaryReader reader = new BinaryReader(provider, true);
        reader.setPointerIndex(4);
        monitor.clearCanceled();
        while (!monitor.isCancelled()) {
            byte type = reader.readNextByte();
            boolean isEndOfFile = false;
            switch (type) {
                case 0: {
                    isEndOfFile = true;
                    break;
                }
                case 2: {
                    int codeSize = reader.readNextUnsignedShort();
                    byte[] bytes = reader.readNextByteArray(codeSize);
                    Section sect = this.sections.get(this.sectionSwitch);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = sect.getBytes();
                    if (byArray != null) {
                        byteArrayOutputStream.write(byArray);
                    }
                    byteArrayOutputStream.write(bytes);
                    sect.setBytes(byteArrayOutputStream.toByteArray());
                    break;
                }
                case 4: {
                    int startSection = reader.readNextUnsignedShort();
                    long startOffset = reader.readNextUnsignedInt();
                    this.runPoints.put(startSection, startOffset);
                    break;
                }
                case 6: {
                    this.sectionSwitch = reader.readNextUnsignedShort();
                    break;
                }
                case 8: {
                    Section sect = this.sections.get(this.sectionSwitch);
                    byte[] bytes = new byte[(int)reader.readNextUnsignedInt()];
                    ByteArrayOutputStream prev = new ByteArrayOutputStream();
                    byte[] byArray = sect.getBytes();
                    if (byArray != null) {
                        prev.write(byArray);
                    }
                    prev.write(bytes);
                    sect.setBytes(prev.toByteArray());
                    break;
                }
                case 10: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    this.patches.add(patchInfo);
                    break;
                }
                case 12: {
                    int symIndex = reader.readNextUnsignedShort();
                    int sectIndex = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    String string = reader.readNextAsciiString((int)reader.readNextByte());
                    XdefSymbol sym = new XdefSymbol(symIndex, string, offset, sectIndex);
                    this.xdefs.add(sym);
                    this.symbols.put(symIndex, sym);
                    break;
                }
                case 14: {
                    int symIndex = reader.readNextUnsignedShort();
                    String name = reader.readNextAsciiString((int)reader.readNextByte());
                    XrefSymbol sym = new XrefSymbol(symIndex, name, (long)(this.xrefs.size() * 4), 0);
                    this.xrefs.put(symIndex, sym);
                    this.symbols.put(symIndex, sym);
                    Section section = this.sections.getOrDefault(0, new Section(0, ".imps", 0, 8));
                    this.sections.put(section.getNumber(), section);
                    break;
                }
                case 16: {
                    int symIndex = reader.readNextUnsignedShort();
                    int groupIndex = reader.readNextUnsignedShort();
                    byte align = reader.readNextByte();
                    String string = reader.readNextAsciiString((int)reader.readNextByte());
                    Section section = new Section(symIndex, string, groupIndex, align);
                    this.sections.put(symIndex, section);
                    this.symbols.put(symIndex, section);
                    break;
                }
                case 18: {
                    int sectionIndex = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    String string = reader.readNextAsciiString((int)reader.readNextByte());
                    this.locals.add(new LocalSymbol(string, offset, sectionIndex));
                    break;
                }
                case 20: {
                    int groupIndex = reader.readNextUnsignedShort();
                    byte groupType = reader.readNextByte();
                    String name = reader.readNextAsciiString((int)reader.readNextByte());
                    this.groups.add(new Group(groupIndex, name, groupType));
                    break;
                }
                case 22: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    int offset = reader.readNextUnsignedShort();
                    RegisterPatch registerPatch = new RegisterPatch(1, patchInfo, offset);
                    this.regPatches.add(registerPatch);
                    break;
                }
                case 24: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    int offset = reader.readNextUnsignedShort();
                    RegisterPatch registerPatch = new RegisterPatch(2, patchInfo, offset);
                    this.regPatches.add(registerPatch);
                    break;
                }
                case 26: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    int offset = reader.readNextUnsignedShort();
                    RegisterPatch registerPatch = new RegisterPatch(4, patchInfo, offset);
                    this.regPatches.add(registerPatch);
                    break;
                }
                case 28: {
                    int fileIndex = reader.readNextUnsignedShort();
                    String name = reader.readNextAsciiString((int)reader.readNextByte());
                    this.defFiles.add(new DefinedFile(fileIndex, name));
                    break;
                }
                case 30: {
                    int fileIndex = reader.readNextUnsignedShort();
                    long lineIndex = reader.readNextUnsignedInt();
                    this.fileLine = new FileLine(fileIndex, lineIndex);
                    break;
                }
                case 32: {
                    this.fileLine.setLineIndex(reader.readNextUnsignedInt());
                    break;
                }
                case 34: {
                    this.fileLine.setLineIndex(this.fileLine.getLineIndex() + 1L);
                    break;
                }
                case 36: {
                    this.fileLine.setLineIndex(this.fileLine.getLineIndex() + (long)reader.readNextByte());
                    break;
                }
                case 38: {
                    this.fileLine.setLineIndex(this.fileLine.getLineIndex() + (long)reader.readNextUnsignedShort());
                    break;
                }
                case 40: {
                    int sectionIndex = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    String string = reader.readNextAsciiString((int)reader.readNextByte());
                    this.vlocals.add(new LocalSymbol(string, offset, sectionIndex));
                    break;
                }
                case 42: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    int offset = reader.readNextUnsignedShort();
                    RegisterPatch registerPatch = new RegisterPatch(3, patchInfo, offset);
                    this.regPatches.add(registerPatch);
                    break;
                }
                case 44: {
                    byte mxInfoVal = reader.readNextByte();
                    int mxOffset = reader.readNextUnsignedShort();
                    this.mxInfos.put(mxOffset, mxInfoVal);
                    break;
                }
                case 46: {
                    reader.readNextByte();
                    break;
                }
                case 48: {
                    int symIndex = reader.readNextUnsignedShort();
                    int sectionIndex = reader.readNextUnsignedShort();
                    long symSize = reader.readNextUnsignedInt();
                    String string = reader.readNextAsciiString((int)reader.readNextByte());
                    List prevList = this.xbssList.getOrDefault(sectionIndex, new ArrayList());
                    XbssSymbol sym = new XbssSymbol(symIndex, string, this.xbssList.size() * 4, symSize, sectionIndex);
                    prevList.add(sym);
                    this.xbssList.put(sectionIndex, prevList);
                    this.symbols.put(symIndex, sym);
                    break;
                }
                case 50: {
                    reader.readNextUnsignedShort();
                    break;
                }
                case 52: {
                    reader.readNextUnsignedShort();
                    reader.readNextByte();
                    break;
                }
                case 54: {
                    reader.readNextUnsignedShort();
                    reader.readNextUnsignedShort();
                    break;
                }
                case 56: {
                    reader.readNextUnsignedShort();
                    reader.readNextUnsignedInt();
                    break;
                }
                case 58: {
                    reader.readNextUnsignedShort();
                    reader.readNextUnsignedInt();
                    reader.readNextUnsignedShort();
                    break;
                }
                case 60: {
                    reader.readNextUnsignedShort();
                    break;
                }
                case 62: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    long count = reader.readNextUnsignedInt();
                    RepeatedData repeatedData = new RepeatedData(patchInfo, count, 1);
                    this.repeatedData.add(repeatedData);
                    break;
                }
                case 64: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    long count = reader.readNextUnsignedInt();
                    RepeatedData repeatedData = new RepeatedData(patchInfo, count, 2);
                    this.repeatedData.add(repeatedData);
                    break;
                }
                case 66: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    long count = reader.readNextUnsignedInt();
                    RepeatedData repeatedData = new RepeatedData(patchInfo, count, 4);
                    this.repeatedData.add(repeatedData);
                    break;
                }
                case 68: {
                    break;
                }
                case 70: {
                    break;
                }
                case 72: {
                    int patchOffset = this.sections.get(this.sectionSwitch).getPatchOffset();
                    PatchInfo patchInfo = new PatchInfo(patchOffset, this.sectionSwitch, reader, log);
                    long count = reader.readNextUnsignedInt();
                    RepeatedData repeatedData = new RepeatedData(patchInfo, count, 3);
                    this.repeatedData.add(repeatedData);
                    break;
                }
                case 74: {
                    int section = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    int n = reader.readNextUnsignedShort();
                    long l = reader.readNextUnsignedInt();
                    int frameReg = reader.readNextUnsignedShort();
                    long frameSize = reader.readNextUnsignedInt();
                    int retnPcReg = reader.readNextUnsignedShort();
                    long mask = reader.readNextUnsignedInt();
                    long maskOffset = reader.readNextUnsignedInt();
                    String name = reader.readNextAsciiString((int)reader.readNextByte());
                    FunctionStart func = new FunctionStart(section, offset, n, l, frameReg, frameSize, retnPcReg, mask, maskOffset, name);
                    this.functionStarts.add(func);
                    break;
                }
                case 76: {
                    int section = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    long l = reader.readNextUnsignedInt();
                    FunctionEnd func = new FunctionEnd(section, offset, l);
                    this.functionEnds.add(func);
                    break;
                }
                case 78: {
                    int section = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    long l = reader.readNextUnsignedInt();
                    BlockStart block = new BlockStart(section, offset, l);
                    this.blockStarts.add(block);
                    break;
                }
                case 80: {
                    int section = reader.readNextUnsignedShort();
                    long offset = reader.readNextUnsignedInt();
                    long l = reader.readNextUnsignedInt();
                    BlockEnd block = new BlockEnd(section, offset, l);
                    this.blockEnds.add(block);
                    break;
                }
                case 82: {
                    int section = reader.readNextUnsignedShort();
                    long value = reader.readNextUnsignedInt();
                    int n = reader.readNextUnsignedShort();
                    int n2 = reader.readNextUnsignedShort();
                    long size = reader.readNextUnsignedInt();
                    String name = reader.readNextAsciiString((int)reader.readNextByte());
                    Definition def = new Definition(section, value, n, n2, size, name);
                    this.defs.add(def);
                    break;
                }
                case 84: {
                    int section = reader.readNextUnsignedShort();
                    long value = reader.readNextUnsignedInt();
                    int n = reader.readNextUnsignedShort();
                    int n3 = reader.readNextUnsignedShort();
                    long size = reader.readNextUnsignedInt();
                    int dims = reader.readNextUnsignedShort();
                    ArrayList<Long> longs = new ArrayList<Long>();
                    for (int i = 0; i < dims; ++i) {
                        longs.add(reader.readNextUnsignedInt());
                    }
                    String tag = reader.readNextAsciiString((int)reader.readNextByte());
                    String tag2 = reader.readNextAsciiString((int)reader.readNextByte());
                    Definition2 def = new Definition2(section, value, n, n3, size, longs, tag, tag2);
                    this.defs2.add(def);
                    break;
                }
                default: {
                    log.appendException((Throwable)new Exception(String.format("%d : Unknown tag", type)));
                    return;
                }
            }
            if (!isEndOfFile) continue;
            break;
        }
        FlatProgramAPI fpa = new FlatProgramAPI(program, monitor);
        for (Integer sectionIndex : this.xbssList.keySet()) {
            List<XbssSymbol> sectXbss = this.xbssList.get(sectionIndex);
            Section sect = this.sections.get(sectionIndex);
            long l = (int)sectXbss.stream().mapToLong(Symbol::getLength).sum();
            sect.setBytes(new byte[(int)l]);
            this.sections.put(sectionIndex, sect);
        }
        if (this.xrefs.size() > 0) {
            Section importsSect = this.sections.get(0);
            long length = (int)this.xrefs.values().stream().mapToLong(Symbol::getLength).sum();
            importsSect.setBytes(new byte[(int)length]);
            this.sections.put(importsSect.getNumber(), importsSect);
        }
        List sortedSections = this.sections.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).filter(p -> ((Section)p.getValue()).getLength() > 0L).map(Map.Entry::getValue).collect(Collectors.toList());
        for (Section sect : sortedSections) {
            sect.doAlign();
        }
        long lastOffset = 256L;
        for (Section section : sortedSections) {
            section.setAddress(lastOffset);
            lastOffset += section.getLength();
        }
        block95: for (XdefSymbol xdefSymbol : this.xdefs) {
            long l = this.sections.get(xdefSymbol.getSectionIndex()).getAddress() + xdefSymbol.getAddress();
            xdefSymbol.setAddress(l);
            for (Section sect : this.sections.values()) {
                if (!sect.getName().equals(".sdata")) continue;
                Object value = new RegisterValue(program.getRegister("gp"), BigInteger.valueOf(sect.getAddress()));
                Address start = fpa.toAddr(l);
                try {
                    program.getProgramContext().setRegisterValue(start, start, (RegisterValue)value);
                    continue block95;
                }
                catch (ContextChangeException e) {
                    log.appendException((Throwable)e);
                    return;
                }
            }
        }
        for (XrefSymbol xrefSymbol : this.xrefs.values()) {
            xrefSymbol.setAddress(this.sections.get(xrefSymbol.getSectionIndex()).getAddress() + xrefSymbol.getAddress());
        }
        for (List list : this.xbssList.values()) {
            for (XbssSymbol xbss : list) {
                xbss.setAddress(this.sections.get(xbss.getSectionIndex()).getAddress() + xbss.getAddress());
            }
        }
        for (LocalSymbol localSymbol : this.locals) {
            localSymbol.setAddress(this.sections.get(localSymbol.getSectionIndex()).getAddress() + localSymbol.getAddress());
        }
        for (LocalSymbol localSymbol : this.vlocals) {
            localSymbol.setAddress(this.sections.get(localSymbol.getSectionIndex()).getAddress() + localSymbol.getAddress());
        }
        for (Section section : sortedSections) {
            String string = section.getName();
            Address start = fpa.toAddr(section.getAddress());
            try {
                byte[] bytes = section.getBytes();
                MemoryBlock block = fpa.createMemoryBlock(string, start, bytes, false);
                switch (string) {
                    case ".rdata": 
                    case ".imps": {
                        block.setRead(true);
                        block.setExecute(false);
                        block.setWrite(false);
                        block.setVolatile(false);
                        break;
                    }
                    case ".text": {
                        block.setRead(true);
                        block.setWrite(false);
                        block.setExecute(true);
                        block.setVolatile(false);
                        break;
                    }
                    case ".data": 
                    case ".sdata": 
                    case ".sbss": 
                    case ".bss": 
                    case ".ctors": 
                    case ".dtors": {
                        block.setRead(true);
                        block.setWrite(true);
                        block.setExecute(false);
                        block.setVolatile(false);
                        break;
                    }
                    default: {
                        block.setRead(true);
                        block.setWrite(true);
                        block.setExecute(true);
                        block.setVolatile(false);
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
                return;
            }
        }
        Memory mem = program.getMemory();
        for (PatchInfo patchInfo : this.patches) {
            int sectionIndex = patchInfo.getSectionIndex();
            Section sect = this.sections.get(sectionIndex);
            byte[] sectionBytes = sect.getBytes();
            Address addr = fpa.toAddr(sect.getAddress() + (long)patchInfo.getOffset());
            long newAddr = patchInfo.calcReference(this.symbols);
            byte[] newBytes = new byte[]{};
            if (patchInfo.getType() != 16) {
                Assembler asm = Assemblers.getAssembler((Program)program);
                DisassembleCommand dism = new DisassembleCommand(addr, null, true);
                dism.applyTo((DomainObject)program, TaskMonitor.DUMMY);
                Instruction instr = listing.getInstructionAt(addr);
                String line = instr.toString().replace("_", "");
                String newLine = "";
                try {
                    switch (patchInfo.getType()) {
                        case 82: {
                            long val = newAddr >= 0L ? newAddr >> 16 & 0xFFFFL : 0L;
                            newLine = line.replaceFirst("-?0x[0-9A-Fa-f]+", String.format("%s0x%X", val < 0L ? "-" : "", val < 0L ? -(val & 0xFFFFL) & 0xFFFFL : val));
                            break;
                        }
                        case 84: {
                            long val = (short)(newAddr >> 0);
                            newLine = line.replaceFirst("-?0x[0-9A-Fa-f]+", String.format("%s0x%X", val < 0L ? "-" : "", val < 0L ? -(val & 0xFFFFL) & 0xFFFFL : val));
                            break;
                        }
                        case 74: {
                            newLine = line.replaceFirst("0x[0-9A-Fa-f]+", String.format("0x%08X", newAddr));
                            break;
                        }
                        case 30: {
                            newLine = line.replaceFirst("0x[0-9A-Fa-f]+", String.format("0x%X", newAddr));
                            break;
                        }
                        case 100: {
                            newLine = line.replaceFirst("0x[0-9A-Fa-f]+", String.format("0x%X", newAddr));
                            break;
                        }
                        default: {
                            log.appendException((Throwable)new Exception(String.format("Unknown patch tag 0x%02X", patchInfo.getType())));
                            return;
                        }
                    }
                    newBytes = asm.assembleLine(addr, newLine);
                    System.arraycopy(newBytes, 0, sectionBytes, patchInfo.getOffset(), newBytes.length);
                }
                catch (AssemblySemanticException | AssemblySyntaxException e) {
                    log.appendException(e);
                    return;
                }
                try {
                    asm.patchProgram(newBytes, addr);
                }
                catch (MemoryAccessException e) {
                    log.appendException((Throwable)e);
                    return;
                }
            }
            newBytes = PsyqLoader.intToBytes((int)newAddr);
            System.arraycopy(newBytes, 0, sectionBytes, patchInfo.getOffset(), newBytes.length);
            try {
                InstructionStasher instructionStasher = new InstructionStasher(program, addr);
                mem.setBytes(addr, newBytes);
                instructionStasher.restore();
            }
            catch (MemoryAccessException | CodeUnitInsertionException e) {
                log.appendException(e);
                return;
            }
            sect.setBytes(sectionBytes);
            if (!patchInfo.isExternal()) continue;
            Symbol sym = this.symbols.get(patchInfo.getExternalIndex());
            Address refAddr = fpa.toAddr(sym.getAddress());
            try {
                if (!listing.isUndefined(refAddr, refAddr.add((long)PointerDataType.dataType.getLength()))) continue;
                fpa.createFunction(refAddr, sym.getName());
                listing.createData(refAddr, (DataType)PointerDataType.dataType);
            }
            catch (DataTypeConflictException | CodeUnitInsertionException e) {
                log.appendException(e);
                return;
            }
        }
        for (XdefSymbol xdefSymbol : this.xdefs) {
            Address offset = fpa.toAddr(xdefSymbol.getAddress());
            try {
                symTbl.createLabel(offset, xdefSymbol.getName(), SourceType.ANALYSIS);
            }
            catch (InvalidInputException e) {
                log.appendException((Throwable)e);
                return;
            }
            DisassembleCommand dism = new DisassembleCommand(offset, null, true);
            dism.applyTo((DomainObject)program, TaskMonitor.DUMMY);
            fpa.addEntryPoint(offset);
            fpa.createFunction(offset, xdefSymbol.getName());
        }
        for (XrefSymbol xrefSymbol : this.xrefs.values()) {
            Address offset = fpa.toAddr(xrefSymbol.getAddress());
            try {
                symTbl.createLabel(offset, xrefSymbol.getName(), SourceType.IMPORTED);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
                return;
            }
        }
        for (LocalSymbol localSymbol : this.locals) {
            Address offset = fpa.toAddr(localSymbol.getAddress());
            try {
                symTbl.createLabel(offset, localSymbol.getName(), SourceType.IMPORTED);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
                return;
            }
        }
        for (LocalSymbol localSymbol : this.vlocals) {
            Address offset = fpa.toAddr(localSymbol.getAddress());
            try {
                symTbl.createLabel(offset, localSymbol.getName(), SourceType.IMPORTED);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
                return;
            }
        }
        for (List<XbssSymbol> list : this.xbssList.values()) {
            for (XbssSymbol xbss : list) {
                Address offset = fpa.toAddr(xbss.getAddress());
                try {
                    symTbl.createLabel(offset, xbss.getName(), SourceType.IMPORTED);
                    CreateArrayCmd array = new CreateArrayCmd(offset, (int)xbss.getLength(), (DataType)ByteDataType.dataType, 1);
                    array.applyTo((DomainObject)program);
                }
                catch (InvalidInputException e) {
                    log.appendException((Throwable)e);
                    return;
                }
            }
        }
    }

    private static byte[] intToBytes(int x) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(x);
        return buffer.array();
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean isLoadIntoProgram) {
        return super.getDefaultOptions(provider, loadSpec, domainObject, isLoadIntoProgram);
    }
}

