/*
 * Decompiled with CFR 0.152.
 */
package psx.debug;

public enum DebuggerCmd {
    CMD_SEND_DUMB(256, DebuggerCmd.noArgs(), ""),
    CMD_GET_PCSXR_VER(257, DebuggerCmd.noArgs(), ""),
    CMD_GET_PROTOCOL_VER(258, DebuggerCmd.noArgs(), ""),
    CMD_GET_STATUS(259, DebuggerCmd.noArgs(), ""),
    CMD_GET_PC_REG(272, DebuggerCmd.noArgs(), "^210 PC=([0-9A-F]{8})$"),
    CMD_GET_GPR_REG(273, DebuggerCmd.oneWordArg(), "^211 ([0-9A-F]{2})\\((\\w+)\\)=([0-9A-F]{8})$"),
    CMD_GET_LO_HI_REGS(274, DebuggerCmd.noArgs(), "^212 LO=([0-9A-F]{8}) HI=([0-9A-F]{8})$"),
    CMD_GET_COP0_REG(275, DebuggerCmd.noArgs(), ""),
    CMD_GET_COP2_CTRL_REG(276, DebuggerCmd.noArgs(), ""),
    CMD_GET_COP2_DATA_REG(277, DebuggerCmd.noArgs(), ""),
    CMD_SET_GP_REG(289, DebuggerCmd.noArgs(), ""),
    CMD_SET_LO_HI(290, DebuggerCmd.noArgs(), ""),
    CMD_SET_COP0_REG(291, DebuggerCmd.noArgs(), ""),
    CMD_SET_COP2_CTRL_REG(292, DebuggerCmd.noArgs(), ""),
    CMD_SET_COP2_DATA_REG(293, DebuggerCmd.noArgs(), ""),
    CMD_DUMP_MEM(304, DebuggerCmd.noArgs(), ""),
    CMD_SET_MEM(320, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_EXEC_MAP(336, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_READ8_MAP(337, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_READ16_MAP(338, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_READ32_MAP(339, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_WRITE8_MAP(340, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_WRITE16_MAP(341, DebuggerCmd.noArgs(), ""),
    CMD_START_STOP_WRITE32_MAP(342, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_EXEC_MAP(352, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_READ8_MAP(353, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_READ16_MAP(354, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_READ32_MAP(355, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_WRITE8_MAP(356, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_WRITE16_MAP(357, DebuggerCmd.noArgs(), ""),
    CMD_BREAK_ON_WRITE32_MAP(358, DebuggerCmd.noArgs(), ""),
    CMD_GET_BPT_COUNT(768, DebuggerCmd.noArgs(), ""),
    CMD_DELETE_BPT(769, DebuggerCmd.noArgs(), ""),
    CMD_SET_EXEC_BPT(784, DebuggerCmd.noArgs(), ""),
    CMD_SET_READ1_BPT(800, DebuggerCmd.noArgs(), ""),
    CMD_SET_READ2_BPT(801, DebuggerCmd.noArgs(), ""),
    CMD_SET_READ4_BPT(802, DebuggerCmd.noArgs(), ""),
    CMD_SET_WRITE1_BPT(816, DebuggerCmd.noArgs(), ""),
    CMD_SET_WRITE2_BPT(817, DebuggerCmd.noArgs(), ""),
    CMD_SET_WRITE4_BPT(818, DebuggerCmd.noArgs(), ""),
    CMD_PAUSE_EXECUTION(912, DebuggerCmd.noArgs(), ""),
    CMD_RESUME_EXECUTION(913, DebuggerCmd.noArgs(), ""),
    CMD_TRACE_EXECUTION(917, DebuggerCmd.noArgs(), ""),
    CMD_SOFT_RESET(920, DebuggerCmd.noArgs(), ""),
    CMD_HARD_RESET(921, DebuggerCmd.noArgs(), ""),
    CMD_RUN_TO(928, DebuggerCmd.oneLongArg(), ""),
    CMD_STEP_OVER(929, DebuggerCmd.noArgs(), "");

    private static final String NO_ARGS = "%03X ";
    private static final String ONE_WORD_ARG = "%03X %02X";
    private static final String ONE_LONG_ARG = "%03X %08X";
    private final int cmd;
    private final String sendFormat;
    private final String recvFormat;

    private DebuggerCmd(int cmd, String sendFormat, String recvFormat) {
        this.cmd = cmd;
        this.sendFormat = sendFormat;
        this.recvFormat = recvFormat;
    }

    public int getInt() {
        return this.cmd;
    }

    public String getSendFormat() {
        return this.sendFormat;
    }

    public String getRecvFormat() {
        return this.recvFormat;
    }

    private static String noArgs() {
        return NO_ARGS;
    }

    private static String oneWordArg() {
        return ONE_WORD_ARG;
    }

    private static String oneLongArg() {
        return ONE_LONG_ARG;
    }
}

