#include "qpsxserial.h"
#include <QApplication>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QStringList param_list;

    for (int i = 1; i < argc; i++)
    {
        param_list.append(argv[i]);
    }

    QPSXSerial w(nullptr, param_list.isEmpty() ? GUI_APP : CLI_APP);

    w.setParamList(param_list);

    if (param_list.isEmpty())
    {
        w.show();
    }
    else
    {
        // This will cause the application to exit when
        // the task signals finished.
        QObject::connect(&w, SIGNAL(finished(void)), &a, SLOT(quit(void)));

        // This will run the task from the application event loop.
        QTimer::singleShot(0, &w, SLOT(cli_run()));
    }

    return a.exec();
}
